\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 20))
  markup-system-spacing = #'((basic-distance . 23))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  %system-count = #3
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Blândul Păstor"
  subtitle = " "
  composer = \markup \center-column { "după Nicolae Moldoveanu" \small
  "(1922 - 2007)" }                                    
  poet = \markup \center-column { "Traian Dorz" \small
  "(1914 - 1989)" }
  %meter = "Adagio"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  \key g \major
  \time 3/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
  %\autoBeamOn
}

womenWordsOne = \lyricmode {
  \set stanza = "1."
  O -- da -- tă L-am vă -- zut tre -- când
  cu tur -- ma pe Păs -- to -- rul blând,
  mer -- gea cu dân -- sa la iz -- vor, __
  blân -- dul Păs -- tor, blân -- dul Păs -- tor;
  mer -- gea cu dân -- sa la iz -- vor, __
  blân -- dul Păs -- tor, blân -- dul Păs -- tor.
}

womenWordsTwo = \lyricmode {
  \set stanza = "2."
  Pe-o oa -- ie ce că -- zu -- se jos
  a ri -- di -- ca -- t-o El du -- ios,
  și-a du -- s-o-n bra -- ţe iu -- bi -- tor, __
  blân -- dul Păs -- tor, blân -- dul Păs -- tor;
  și-a du -- s-o-n bra -- ţe iu -- bi -- tor, __
  blân -- dul Păs -- tor, blân -- dul Păs -- tor.
}

womenWordsThree = \lyricmode {
  \set stanza = "3."
  Pe al -- ta, ca -- re la pă -- mânt
  ză -- cea cu pi -- cio -- ru -- șul frânt
  El o le -- ga, mân -- gâ -- ie -- tor, __
  blân -- dul Păs -- tor, blân -- dul Păs -- tor;
  El o le -- ga, mân -- gâ -- ie -- tor, __
  blân -- dul Păs -- tor, blân -- dul Păs -- tor.
}

womenWordsFour = \lyricmode {
  \set stanza = "4."
  El le-a iu -- bit cu dor ne -- spus
  şi via -- ţa pen -- tru oi Şi-a pus
  şi pen -- tru mân -- tu -- i -- rea lor, __
  blân -- dul Păs -- tor, blân -- dul Păs -- tor;
  şi pen -- tru mân -- tu -- i -- rea lor, __
  blân -- dul Păs -- tor, blân -- dul Păs -- tor.
}

womenWordsFive = \lyricmode {
  \set stanza = "5."
  Și-a -- tun -- cea o -- i -- le-au ve -- nit,
  pe cru -- ce, sus, L-au răs -- tig -- nit,
  El se ru -- ga spre mi -- la lor, __
  blân -- dul Păs -- tor, blân -- dul Păs -- tor;
  El se ru -- ga spre mi -- la lor, __
  blân -- dul Păs -- tor, blân -- dul Păs -- tor.
}

womenWordsSix = \lyricmode {
  \set stanza = "6."
  
}

menWords = \lyricmode {
  
}

sopMusic = \relative c' {
  d4
  g2 g4 a2 g4 fis2 e4 d2^\fermata \breathe
  d4 a'2 a4 h2 a4 g2 a4 h2^\fermata \breathe
  h4 c2 c4 c2 c4 d2 c4 h2( a4 g2) h4\rest
  h4 c h a2. d4 d c h2^\fermata
  h4 c2 c4 c2 c4 d2 c4 h2( a4 g2) h4\rest
  h4 c h a2. d4 d c h2.^\fermata
  \bar "|."
}

altMusic = \relative c' {
  d4 g2 g4 fis2 g4 fis2 e4 d2
  d4 fis2 fis4 g2 a4 g2 fis4 g2
  %d4 fis2 fis4 fis2 fis4 e2 fis4 d2
  g4 g2 g4 a2 g4 g2 g4 d2( fis4 g2) h4\rest
  d,4 g h a2. d,4 fis a g2
  g4 g2 g4 a2 g4 g2 g4 d2( fis4 g2) h4\rest
  d,4 g h a2. d,4 fis a g2.
}

tenorMusic =  \relative c {
  d4 g2 g4 a2 g4 a2 h4 a2
  a4 a2 a4 h2 c4 d2 d4 d2
  d4 e2 e4 e2 e4 d2 c4 h2( h4 h2) d,4\rest
  g4 g g fis2. fis4 fis fis g2
  g4 g2 g4 g2 g4 g2 g4 g2( g4 g2) d4\rest
  g4 g g fis2. fis4 fis fis g2.
}

bassMusic = \relative c {
  d4 g2 g4 fis2 e4 d2 d4 d2
  d4 d2 d4 d2 d4 d2 d4 g2
  g4 c,2 c4 c2 c4 c2 c4 d2( d4 g2) d4\rest
  g4 g g d2. d4 d d <g g,>2
  g4 c,2 c4 c2 c4 c2 c4 d2( d4 g2) d4\rest
  g4 g g d2. d4 d d <g g,>2.
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
     \addlyrics { \womenWordsOne }
     \addlyrics { \womenWordsTwo }
     \addlyrics { \womenWordsThree }
     \addlyrics { \womenWordsFour }
     \addlyrics { \womenWordsFive }
     \addlyrics { \womenWordsSix }
     \new Voice { \voiceTwo \global \altMusic }
     %\addlyrics { \womenWordsOne }  
     >>
    
    \new Staff <<
      \clef bass
      %\new Voice { \global \bassMusic }
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      %\new Voice { \global \bassMusic }
      \addlyrics { \menWords }
      >>
    
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
   \tempo 4 = 120
   \context { \Voice \remove "Dynamic_performer" }
}

\score {
  %\unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}